local t = Def.ActorFrame{};
local gridLength = 25
local gridZoomFactor = 0.3
local width = 24
local meter = 25

local function DifficultyInfo(pn)
	if GetDifficulty(pn) == nil then return "????" end
	if GetMeter(pn) == nil then return "????" end
	if GetDescription(pn) == nil then return "????" end
	return GetDifficulty(pn) .. " " .. round(GetMeter(pn) * RateModUpdateFunction()) .. ", " .. GetDescription(pn)
end

for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = Def.ActorFrame{
		CommonNormal()..{
			Name="Difficulty"..ToEnumShortString(pn);
			InitCommand=cmd(y,Top()+60;zoom,0.5;align,0,1;uppercase,true;maxwidth,534;visible,IsPlayerEnabled(pn));
			OnCommand=function(self)
				self:x(Left()+8)
				if GetCurrentSong() then self:settext(DifficultyInfo(pn) or "???"):diffuse(CustomDifficultyToColor(GetRawDifficulty(pn))) else self:settext(""):diffuse(CustomDifficultyToColor("Difficulty_Edit")) end
			end;
			CurrentSongChangedMessageCommand=cmd(playcommand,"On");
			CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"On");
			CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"On");
			RateModChangedMessageCommand=function(self,params) if pn == PLAYER_1 then self:settext(DifficultyInfo(PLAYER_1)) else self:settext(DifficultyInfo(PLAYER_2)) end end;
		};
		LoadActor("_block")..{
			Name="Ticks BG "..ToEnumShortString(pn);
			InitCommand=cmd(y,Top()+80;align,0,1;diffuse,ColorDarkTone(White()));
			OnCommand=function(self)
				local height = self:GetHeight();
				self:x(Left()+7)
				self:zoomto(width * meter * gridZoomFactor * 1.5, height * gridZoomFactor);
				self:customtexturerect(0, 0, meter, 1);
			end;
		};
		LoadActor("_block")..{
			Name="Ticks"..ToEnumShortString(pn);
			InitCommand=cmd(y,Top()+80;align,0,1);
			OnCommand=cmd(playcommand,"Update");
			CurrentSongChangedMessageCommand=cmd(playcommand,"Update");
			CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Update");
			CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Update");
			UpdateCommand=function(self)
				self:x(Left()+7)
				local Meter = round(GetMeter(pn))
				local height = self:GetHeight();
				if Meter > gridLength then Meter = gridLength end
				if GetCurrentSong() then
					self:zoomto(width * Meter * gridZoomFactor * 1.5, height * gridZoomFactor);
					self:customtexturerect(0, 0, Meter, 1):diffuse(CustomDifficultyToColor(GetRawDifficulty(pn))):visible(true)
				else
					self:visible(false)
				end
			end;
		};
	};
end

return t